# Intersectionality and coalitions in social movements – a survey and outlook

# Author:

Dr Silke Roth Professor of Sociology Department of Sociology, Social Policy and Criminology University of Southampton Southampton, SO17 1BJ United Kingdom e-mail: silke.roth@soton.ac.uk Orcid: https://orcid.org/0000-0002-8760-0505

# Authors version, accepted for publication by Sociology Compass, 17 March 2021

# Abstract

Over the last thirty years, intersectionality has become a prominent concept, but in social movement scholarship its adoption has yet been limited. So far, the concept is primarily employed to analyze the mobilisation of women of color and other gendered mobilizations. In this article, I argue that intersectionality matters for all social movements – both as an analytic and as a political strategy. It is important to understand that all social movements and movement organizations are shaped by multiple axes of privilege and discrimination which influence who participates in these movements and how, what demands are pursued and which are neglected, and how the issues of the movements and movement organizations are framed. My review starts out with defining and distinguishing between structural intersectionality and political intersectionality. Then I survey a range of social movements from an intersectional perspective. This is followed by a discussion of coalitions and other strategies to achieve political intersectionality. The article concludes with an outlook on future directions for intersectional analyses in social movement scholarship. (170 words)

Keywords: Black Lives Matter, coalitions, inclusion, LGBTQ $^ +$ , political intersectionality, structural intersectionality, women of color

Acknowledgements: I would like to thank Leslie Bunnage for her enthusiasm, support and commissioning this article. Many thanks to the reviewers for their perceptive and constructive criticism. Furthermore, I am grateful to Myra Marx Ferree and Clare Saunders for helpful feedback on an earlier version of this article.

# Intersectionality and social movement research

Over the course of the last three decades, the concept of intersectionality has become increasingly prominent (Carbado & Harris 2019), particularly in gender studies (Cho, Crenshaw & McCall 2013) and in the studies of women’s movements (see for example Beckwith 2000; Ferree 2009; Bassel & Emejulu 2010; Verloo 2013; Lepinard 2014; Roth 2017a; Irvine, Montoya & Lang 2019). It is primarily associated with Kimberlé Crenshaw (1989;1991) who argued that in order to understand the position of women of color one needs to take into consideration multiple forms of disadvantage and marginalization. Women of color are responding to the matrix of domination (Hill Collins 1990) – the interconnection of race/class/gender -- in a range of social movements, including women’s and civil rights movements – at local, national and transnational levels (Hill Collins 2012; Roth 2017a). These activists and their allies respond to multiple and intersecting forms of disadvantage and criticize movements which prioritize only one form of discrimination. Thus, it is important to acknowledge that every social movement is shaped by different forms of privilege and disadvantage which affect inclusion, participation, the framing of issues and the agendas of social movements (Einwohner et. al. 2019). So far social movement research has employed intersectional perspectives only to a limited extent (Luna, Jesudason & Kim 2020). In this article, I demonstrate that it is necessary to acknowledge that every social movement and social movement organization is shaped by multiple intersecting inequalities and power dynamics. An intersectional perspective allows us to see whether movements which mobilize for economic justice take into account how class differences intersect with race, gender, heteronormativity and other structures of inequality. Similarly, an intersectional perspective highlights what roles class, gender and heteronormativity play in civil rights movements and to what extent LGBTQI movements acknowledge race, class and gender differences. Importantly, an intersectional perspective on social movements draws attention to unmarked and privileged categories. This means that adopting an intersectional perspective encourages social movements and those who study them to ask: How homogenous or heterogeneous are the constituencies and leadership of social movements and to what extent do the agendas of these movements reflect their homogeneity or heterogeneity? I argue that social movement scholarship benefits from explicitly adopting an intersectional perspective in order to take into account that:

“…employment opportunities and promotion for Black workers do not necessarily provide justice for Black women. Antiracist organizing can be uncritical about misogyny. Homophobia can seep into feminist and antiracist mobilizations alike, while race and class privilege can be unexamined within queer politics.” (Chun, Lipsitz & Shin 2013, p. 923)

The concept of intersectionality has been employed to de-center gender in women’s movements but it has so far found less use in the context of other social movements (Einwohner et al. 2019; Irvine, Montoya & Lang 2019; Luna, Jesudason & Kim 2020). Moreover, efforts to achieve intersectionality in social movements -- and thus de-centering race, class and gender -- have been uneven (Milkman 2017). Importantly, de-centering does not mean that the importance of gender, class and racial inequalities is denied, but to acknowledge and address how multiple systems of inequality intersect (Walby 2009; Choo & Ferree 2010; Hill Collins 2015; Roth 2017a). Extending the concept of intersectionality to the analysis of privileged groups thus draws attention to unmarked categories (Carbado 2013; Choo & Ferree 2010), rather than “de

politicizing” (Mohanty 2013) or “whitening” the concept (Bilge 2013; 2014). This is particularly important for the analysis of movements such as environmental movements which might not seem to be defined by gender, class or race. However, as I will demonstrate in this article, all social movements are shaped by various forms of privilege and disadvantage, recruiting participants from different socio-economic backgrounds who differ by gender, race, nationality etc. (Ransby 2015). The environmental movement has for a long time been perceived as a white middle-class movement (Taylor 1997), but it encompasses organizations fighting for environmental justice and mobilizes working class, poor and ethnic minority constituencies. An intersectional perspective on social movements contributes to a better understanding of inclusion and marginalization of groups and their interests and helps to analyze conflicts that are grounded in the diversity of their constituencies. Thus, an intersectional perspective encourages social movements and those who study them to assess the need for and the efforts to develop inclusive strategies (Einwohner et al. 2019). Drawing on Patricia Hill Collins (2015), I understand intersectionality both as an analytic strategy and a form of critical political practice. In the next section, I define structural and political intersectionality. The following section surveys a variety of social movements from an intersectional perspective. Subsequently, I discuss coalitions and other strategies to achieve political intersectionality in social movements. The article ends with an outlook for future research needs.

# Structural and Political Intersectionality

Structural intersectionality focuses on the effects of multiple subordination, for example how immigrant status and unemployment shape the experience of domestic violence (Crenshaw 1991). It can be experienced at the individual or group level, people might be multiply

disadvantaged or multiply privileged or disadvantaged in some and privileged in other respects. Structural intersectionality informs positionality or how participants experience their social status – for example with respect to gender, class, race, ethnicity, age, or sexuality. Positionality matters for “how grievances are identified, causes framed, adversaries understood, […], potential allies are approached and collaborations sustained (or not)” (Beamisch & Luebbers 2009, p. 652). This means that organizations, movements and coalitions have to take the different positionalities of their constituencies and allies into account. It has long been established that women of color sit at the intersection of potentially conflicting agendas of (white) women’s movements and (male dominated) civil rights movements and are potentially marginalized by both movements (Hull, Bell Scott & Smith1982). Political intersectionality concerns how the positionality of multiple disadvantaged groups shapes the construction of collective identities (which experiences are put into the foreground, which are downplayed or excluded?) and how they affect the framing of agendas and the choice of strategies (Crenshaw 1991). Political intersectionality encompasses the efforts to achieve inclusion and to mitigate power differentials within and between movements and organizations.1)

Intersectional perspectives help us to better understand who is represented by and involved in social movements and what consequences this has for the actions of movements and movement organizations (Einwohner et. al. 2019). Thus, it matters not only who participates in social movements, but also how power differences and inequality among members shape the agendas of social movements and social movement organizations (Subramaniam & Krishnan 2019; Einwohner et. al. 2019). An awareness of structural intersectionality is important to develop strategies to achieve political intersectionality (Einwohner et al. 2019). It is important to avoid overlooking racial and gender privilege which would result in colorblind (and genderblind) intersectionality (Carbado 2013). Even advocacy groups which mobilize against various forms of discrimination (related to class, gender, race and sexuality) tend to put more effort into pursuing the interests of the majority and advantaged subgroups rather than those who are most disadvantaged as Strolovitch (2007) demonstrates. In the next section I survey a range of social movements from an intersectional perspective.

# Intersectional Perspectives on Social Movements

My survey of structural and political intersectionality in a variety of social movements starts out with women’s movements and in particular the mobilization of women of color which are most prominently associated with the concept of intersectionality, followed by a discussion of civil rights movements and LGBTQ movements. Then I turn to labor, environmental, and right-wing and racist movements.

# Women’s movements and the mobilization of women of color

Women’s movements tend to be perceived as being dominated by white middle-class women (Roth 2004; Ferree & McClurg Mueller 2007). However, these movements have always included working-class women, women of color, straight and lesbian women (obviously not mutually exclusive categories!) and engaged in political intersectionality. Cross-class coalitions existed in the US since the early $2 0 ^ { \mathrm { t h } }$ century – for example in the Women’s Trade Union League and Chicago’s Hull House in which white middle class reformers such as Jane Addams sought to support the unionization of women workers and improve the working and living conditions of working class and immigrant women (Deegan 1988). The interaction between working-class and middle-class women, white women and women of color is thus at the same time characterized by solidarity and support and by conflict and power differentials (Ferree & Hess 2000).Women of color, working class women, immigrant women, lesbians and transwomen have criticized the white, middle-class, cis-gender, straight women’s movement of marginalizing and ignoring their needs and experiences. They have also mobilized separately and founded “their own” organizations (Roth 2004). Moreover, women of color organizations acknowledge and address the heterogeneity of their experiences. Based on her study of the organization SisterSong, Luna (2016) identifies two different logics to do cross-racial work: “same difference” which emphasizes similar experience and “difference in sameness” which recognizes different experiences and thus seeks to consciously seeks to avoid marginalization, silencing and inequality. Moreover, women of color are aware of the relatedness of structures of oppression and “black feminist organizers around the country have deeply immersed themselves in struggles that incorporate but are not isolated to gender issues” (Ransby 2000, p. 1218), for example in reproductive justice coalitions (Luna 2016; Roberts & Jesudason 2016; Zavella 2017) or Black Lives Matter (discussed below). After the financial crisis, minority women in France and the UK engaged in anti-austerity activism and intersectional work by combining welfare service provision, advocacy and grassroots mobilization (Bassel & Emejulu 2017).

One example of the challenges to achieve political intersectionality is the Women’s March on Washington (WMW) and other women’s marches in the United States in January 2017, which were attended by about four million participants (Milkman 2017; Einwohner et al. 2019; Fisher 2019). It was one of the largest protests in the history of the United States and accompanied by many similar demonstrations around the world (Boon, Secci & Gallan 2018). Organizers made conscious and successful efforts to include prominent activists representing a wide range of different communities, and mobilize participants across gender, class, race, ethnicity and sexuality (Boon, Secci & Gallan 2018, p. 357). While participants prioritized the social identities that were most salient to them, they “were motivated by a diverse set of issues connected to intersectional concerns” (Fisher, Dow & Ray 2017, p. 5). Nevertheless, the event was criticized for failing to be truly inclusive and the perception of WMW was shaped by a variety of aspects. Some local marches seemed more inclusive (Doan 2017) than others (Rose-Redwood & RoseRedwood 2017). The positionality of the observer mattered (Boothroyd et al. 2017; Burke et al. 2017; Doan 2017; Falola & West Ohueri 2017; Gökarıksel & Smith 2017; Moss & Maddrell 2017; Rose-Redwood & Rose-Redwood 2017), and whether observers described early or later stages of the organization of the event. Thus, even for movements that are aware of structural intersectionality it is a challenge to achieve political intersectionality.

# Civil Rights Movements

Just as sexuality, race, ethnicity and nationality matter for the involvement in and actions of women’s movements, they matter for civil rights movements. Women played a significant, but invisible role in the American civil rights movement (Barnett 1993; Robnett 1996; Brown, Ray, Summers & Fraistat 2017; Ransby 2018) and sexism in the civil rights movement sparked the second wave of the women’s movement (Evans 1979). Criticism of (hetero) sexism within the civil rights movement or in ethnic communities had been discouraged by (male, heterosexual) leaders out of fear that it might undermine the unity of the movement and damage its reputation (Clark, Dantzler & Nickels 2018). Such an essentialist understanding of anti-racist politics excludes and makes invisible women, gays and lesbians of color (Ransby 2015; 2018). But

African (American) women’s activism in civil rights and anti-apartheid movements is well documented (Brown, Ray, Summers & Fraistat 2017; Ransby 2018). As “bridge-leaders”, they were involved in recruitment processes and connected social movement organizations with potential participants (Robnett 1996). In the South African Civil Rights movement women also took on an important role and formed autonomous organizations (Kuumba 2001). The combination of men’s political repression, women’s relative freedom of movement and the dominance of men in social movement organizations resulted in women’s central bridging role in the American civil rights movement and the South African anti-apartheid movement (Kuumba 2002).

Anti-racist activism comprises groups representing themselves and those supporting racialized groups, ethnic minorities and migrants (Hill Collins 1990). Many studies of women in anti-racist movements focus on the reconciliation of feminist and anti-racist identities and the tensions between majority and minority women (Anthias & Yuval-Davis 1993; Mohanty 2003; Roth 2004; Cohen 2012; de Jong 2017). The involvement of Northern white middle-class activists in the civil rights movement in the American South is well documented (McAdam 1988). In fact, their involvement is reflected in a change of organizational structure and strategy. Francesca Polletta (2005) argues that African American activists in the Student Nonviolent Coordinating Committee (SNCC), one of the most important organizations of the American civil rights movement, initially employed participatory decision making to train a new generation of activists, to acknowledge local conditions, and to prevent the domination of Northern white middle-class activists who were more familiar with parliamentary procedure. However, after Freedom Summer campaign the preference for decentralized structure and consensus became associated with white intellectuals and abandoned by black SNCC staff (Polletta 2005). Thus, class and race mattered for cooperation and tensions within the movement.

There are both continuities and discontinuities between the Civil Rights Moment (CRM) and Black Lives Matter (BLM) which emerged in 2013 in response to police brutality (Oliver 2020). The women who founded BLM emphasized the centrality of women and LGBTQ issues (Garza 2014). Continuities between CRM and BLM include Black Feminist activism which has always been intersectional, going back to the colonial era (Brown, Ray, Summers & Fraistat 2017) and the emphasis on local protest and local coalitions (Oliver 2020). At the same time, it is important to recognize discontinuities between CRM and BLM. The latter rejected sexism and homophobia, the goal to achieve “respectability” and the rejection of patriarchal and hierarchical structures which characterized the former (Clark, Dantzler & Nickels 2018). Thus, BLM represents an attempt to “rebuild” the CRM while at the same time being “unapologetically Black, transgender affirming, queer affirming, intergenerational” (Clark, Dantzler & Nickels 2018, p. 146; see also Milkman 2017). However, Melissa Brown and her co-authors (2017) note that due to the difficulties of envisioning more than one monolithic identity, there is a risk that Black women will be erased in BLM. This is despite or because of the challenges of intersectional activism, even though a large proportion of BLM activists are women, and more than half identify as LGBTQ (Milkman 2017, p. 23). In addition, Fisher (2020) found that $5 4 \%$ of the participants in BLM protests were white. BLM protests thus were considerably more racially diverse than some of the large-scale anti-Trump protests (Fisher 2019; 2020).

Intersectional perspectives are highly relevant for the study of LGBT movements as sexuality intersects with gender, class, race and ethnicity and so on. Benita Roth (2017b) analyses AIDS activism including gays and lesbians, drug users2) , people of color, women and straights – obviously overlapping categories! She notes that the recruitment and political socialization of various micro-cohorts within ACTUP/LA resulted in tensions between white male homosexuals, straight women and people of color. ACTUP/LA formed caucuses in order to acknowledge that the AIDS crisis is experienced differently for different sub-groups (gay middle-class men, people of color, drug users). Benita Roth (2017b) analyses three “intersectional crises” which were a result of an influx of participants, disputes around a needle exchange project and efforts to reach more people of color, and the responses to LGBT protests at the national level. The analysis of this highly diverse organization demonstrates that its heterogeneous constituency shaped strategic choices and organizational developments. Thus, an intersectional perspective on LGBT and Anti-AIDS movements highlights both the conflicts that movements and movement organizations experience as well as the efforts to overcome them.

Some goals of the gay and lesbian movement – in particular same-sex marriage – reflect interests of white middle-class homosexuals, overlooking that this demand has little to do with nonnuclear family arrangements in poor communities of color for whom marriage hardly provides economic benefits (Hutchinson 2000). Based on a study of the European LGBTI movement, Ayoub (2019) found that it is easier to adopt intersectional consciousness and intersectionality as a political framework than to develop truly inclusive movements. His study reveals that white gay men with middle/upper class status tended to be overrepresented in leadership and decisionmaking bodies, “whereas trans, intersex and bi-sexual people (and their claims) are especially underrepresented” (Ayoub 2019, p. 20). Thus, even movements which are aware of structural intersectionality and seek to achieve political intersectionality fail at achieving it (see also Strolovitch 2007). Thus, it is not surprising that LGBTQ Youth of Color felt marginalized by the white and middle-class dominated LGBTQ community and the patriarchal and heteronormative Latina Culture (Irazabal & Huerta 2016). However, despite these obstacles LGBTQ activists also engage successfully in intersectional cross-movement mobilization as the example of the undocumented immigrant youth movement DREAMERS demonstrates (Costanza-Chock 2014; Terriquez 2015; Milkman 2017). The leaders of this movement consciously addressed homophobia and employed strategies to validate the experiences of LGBTQ members (Terriquez 2015). Thus, in women’s, civil rights and LGBTQ movements efforts to achieve political intersectionality are made, even if they are not always fully achieved. I will now turn to movements which have less often been analyzed from an intersectional perspective.

# Labor and workers movements

Labor movements in many countries initially represented the interests of white, native-born men, excluding women, migrants and ethnic minorities and ignoring the interests of gay and lesbian members (Cockburn 1983; Dubofsky & Dulles 2014; Marks 2014). Thus, the relationship between women and other groups that were excluded from trade unions is long and complex. The participation of women in the labor movement reflects their inclusion in the paid labor force, sex-segregated labor markets and the dominance of men in trade unions (Milkman 1990; Roth 2003). Worldwide, trade unions have experienced declining traditional membership due to economic restructuring and a growing workforce in the previously less organized service and

public sectors. They have, to varying degrees, begun to reframe trade union identities in order to mobilize presumably “non-traditional” labor constituencies such as women and ethnic minorities (Perrett & Lucio 2009; Dixon & Martin 2012; Mustchin 2012) and started to organize part-time workers (Heery & Conley 2007). The increase of women in union membership and in union leadership thus reflects the increasing labor force participation of women, the restructuring of labor markets as well as conscious efforts to bring more women into leadership positions (Fonow 2003; Roth 2003; Stuart, Tomlinson & Lucio 2013; Kirton & Healy 2013). Milkman (2018) notes that white men now represent the minority $( 4 2 \% )$ of US union members, whereas $5 8 \%$ of US union members are women and people of color. However, based on an evaluation of Union Summer program of the US labor federation AFL-CIO, Bunnage (2014) observes entrenched racial and gender dynamics in the culture of the US labor movement.

From an intersectional perspective, it is of interest how the increased participation of women and ethnic minorities has shaped the agenda of the labor movement and to what extent their needs and interests are framed as “labor issues”, rather than “women’s issues” and “civil rights issues” (Roth 2003). For example, when Black women are overrepresented in the US public sector then public sector cuts and attacks on public sector unions affect primarily women of color (Chavez 2012; see also Bassel & Emejulu 2014). The American Federation of State, County and Municipal Employees (AFSMCE) has a very large proportion of women and ethnic minorities among membership and leadership. Martin Luther King Jr. was assassinated when he supported AFSCME members at a protest, an example of how labor, civil rights and gender issues intersect (Chavez 2012). This means that union-busting in the public sector does not only concern worker’s rights, but also women’s and civil rights. However, even prominent civil rights leaders like the Reverend Jesse Jackson who is known for his commitment to anti-racism and coalition politics focused solely on worker’s rights at a rally against union-busting in Wisconsin (Chavez 2012).

These examples show very clearly how “labor” issues are simultaneously class, gender and civil rights issues. Attacks on public sector unions affect all public sector workers but “some workers, with certain identities, will be disproportionately impacted, and [that] those workers are also the ones who are already more likely to be more systematically oppressed” (Chavez 2012, p. 28). Thus, an emphasis on “solidarity” focusing solely on class and neglecting other aspects of inequality obscures the fact that various groups of workers are differently affected by labor struggles. “Exclusionary solidarity” that focuses solely on class without acknowledging how different forms of privilege and inequality intersect, can impede coalition-building (Ferree & Roth 1998). Given segmented labor markets, gender differences in career patterns, difference in working conditions in the private and public sectors, different rights of those with or without citizenship rights and different rights of heterosexual and same-sex couples, “labor” issues vary with respect to gender, sexuality, race, ethnicity and nationality and require “active solidarity” (Einwohner et al. 2019) which acknowledges structural and pursues political intersectionality.

One strategy to make labor movements more inclusive is by organizing underrepresented groups, creating caucuses within trade unions and by acknowledging that gender, civil rights and LGBT issues are workers issues (Roth 2003). Women’s, civil rights and LBGT movements challenged labor movements to pay more attention to these excluded, marginalized and ignored groups which are also part of the labor force and thus in need of workplace representation (Baron 1991).

Based on a study of UK unions, Edmund Heery, Steve Williams and Brian Abbott (2012) distinguish three relationships between unions and other groups: cooperation, conflict and indifference. Cooperation includes joint campaigns and coalitions on issues including human rights abuse, the protection of asylum seekers or campaigns for a living wage. Furthermore, some civil society organizations deliberately appointed officers with a trade union background in order to strengthen their links with the labor movement (Heery, Williams & Abbott 2012, p. 152). However, Edmund Heery and his co-authors (2012) also note conflict, for example between women and LGBT groups who felt that they were not supported by trade unions. Finally, they observe indifference or lack of contact between trade unions and women’s organizations who were concerned with developing the skills and supporting the careers of women (p. 156). Thus, another strategy is to organize outside the labor movement. Asian Immigrant Women Advocates (AIWA), an organization established in 1983, is such an example of political intersectionality. Representing Asian immigrant women working in low-paid manufacturing and service jobs, the organization simultaneously addressed sexism, racism, class oppression, nativism and language discrimination (Chun, Lipsitz & Shin 2013). This means that as long as labor markets and workplaces are segmented by race, class and gender, political intersectionality and active solidarity are needed. Moreover, it also implies that scholarship of labor movements and other organizations representing the workforce benefit from an intersectional perspective (Moore & Taylor 2020).

# Environmental movements

Intersectionality also plays a role for environmental movements which are highly diverse and include different goals, strategies and constituencies and a broad range of reformist and radical organizations (Saunders 2013). They include conservatism and NIMBYISM (not-in-my-backyard) associated with white middle-class constituencies, occupational health campaigns of working-class communities, and environmental justice campaigns of deprived communities living in environments most affected by pollution (Taylor 1997; Saunders 2013). The intersection of class and environmental issues becomes particularly salient when one considers the location of incinerators, power plants or the dumping of toxic chemicals that pose significant health risks in poor neighborhoods (Bullard 1990; Di Chiro 2008). Framing processes played a central role for successful cross-class coalition building of the New Jersey Right-to Know Coalition which mobilized against the use, storage, and transportation of toxic substances (Mayer, Brown, & Morello-Frosch 2010). In this case, health and safety activists from the labor movement broadened the frame of workplace health to an issue of concern of the broader population which resonated with (middle-class) environmental activists.

In addition to ethnicity and class, gender plays a significant role for environmental activism, not just with respect to ecofeminism (Mann 2011). Environmental pollution is associated with a wide range of reproductive health risks “including ovarian cancer, breast cancer, birth defects, endocrine irregularities, declining sperm counts, endometriosis and infertility” (Di Chiro 2008, p. 289). Furthermore, the construction of overpopulation as an environmental problem and framing access to abortion as a women’s right erases the experiences of women of color who are confronted by policies which discourage or prohibit motherhood and stigmatize large families (Di Chiro 2008). Thus, an intersectional perspective highlights that “all environmental issues are reproductive issues” (Di Chiro 2008, p. 285), and impact men and women of different socioeconomic and racial-ethnic backgrounds differently.

The involvement in environmental movements and the framing of environmental issues is shaped by gender, class, and ethnicity (Taylor 1997). Gender identities played a central role for involvement in the environmental justice movement in the coalfields of Central Appalachia (Bell & Braun 2010). Women framed their engagement in the fight to protect their families from dangers related to mountaintop removal coal mining as an extension of their responsibilities as mothers. Men’s “coal-mining identity” was also intertwined gender ideology (“male breadwinner”) and prevented them from getting involved in the struggle (Bell & Brown 2010). Nevertheless, while women, working-class and ethnic communities are involved in the environmental movement, white middle class men are so far dominating environmental organizations (Taylor 2015). This dominance poses the risk that the concerns of women, working class and racialized communities might be marginalized. Intersectionality matters not only for social movements on the left, but social movements from the right to which I turn next.

# Right-Wing and Racist Movements

While it is quite clear that race, ethnicity and nationality matter in right-wing and racist movements, gender and class matter just as much. This becomes quite obviously when racists claim that white men are victims of reverse discrimination (or affirmative action) (Schroer 2008) and other core gains of the civil rights and gender equality movements (Ferree 2020). White men who feel victimized and disadvantaged by social change – which according to their perspective benefited women, migrants and ethnic minority men – assert their superiority vis-a-vis these groups (Ferber 2000; Hughey 2012). Nationalist and racist organizations are sites of the construction of white masculinities (Ferber 2000). However, it is important to note that

nationalist and racist movements include white working-class and middle-class men and women (McVeigh 1999; McVeigh & Estep 2019; Simi, Futrell & Bubolz 2016).

Francesca Scrinzi (2015) presents a fascinating ethnographic study of the French right-wing party National Front $( \mathrm { N F } ) ^ { 3 ) }$ based on interviews with male and female, working-class and middle class, white and racialized party members. These groups represented different narratives and identities. White middle-class respondents “avoided an ethno-nativist discourse” and instead criticized political and economic elites, neoliberal capitalism, and globalization (Scrinzi 2015, p. 62). In contrast, the working-class respondents perceived migrants and racialized groups as enemies while also criticizing the elites. African and North African NF members felt threatened by migrants, whereas white working-class respondents (including migrants) perceived racialized groups as enemy. Racist and right-wing movements and organizations thus include people from different class backgrounds and racial-ethnic groups.

Furthermore, the involvement of women in racist movements has steadily increased, even though women tend to be underrepresented in leadership positions (Blee & Deutsch 2012; Blee 2016). Nevertheless, in some countries, for example France and Germany, women have taken on leadership positions in nationalist parties. Geva (2020) argues that Marie Le Pen, the leader of the French Front National symbolizes both feminine and masculine virtues. Thus, race, class and gender all matter for the involvement, identities and narratives of nationalist and racist movements. After having surveyed six different movements from an intersectional perspective, in the next section I will discuss coalition building and other strategies to achieve political intersectionality.

# Coalitions and other strategies to achieve political intersectionality

Among the strategies to achieve political intersectionality, coalition-building plays a central role (Bystydzienski & Schacht 2001; Strolovitch 2007; Cole 2008; Cole & Luna 2010; Van Dyke & McGammon 2010; Agustin & Roth 2011; Einwohner et. al 2019). Coalitions can bridge any combination of social movements and social movement organizations addressing class, gender, race, ethnicity, environmental or any other issue (Bystydzienski & Schacht 2001; Gawerc 2020). Alliances which cross the class-divide and other inequalities require the work of bridge-builders (Rose 1999; Roth 2003; Gawerc 2020; Montoya & Seminario 2020), who are capable of translating between different movements and their cultures. For example, coalition building between labor, peace and environmental movements requires overcoming entrenched divisions and differences between working-class communities that are focusing on jobs and economic security and middle-class activists that are supporting peace and environmental issues. Such cross-class coalitions need to address the positionality of white middle-class and of poor working-class ethnic minority activists (Beamish & Luebbers 2009). Coalition-building requires successful frame alignment (Benford & Snow 2000), conscious efforts of building trust, recognizing joint interests, respecting different cultures and acknowledging power differentials. The WMW discussed above provides a good example for the role of coalitions and communication and the need to mobilize diverse constituencies and the challenges to crafting solidarities across difference.

Based on her study of the March for Women’s Lives, Luna (2010) demonstrates that such coalition work can have lasting impact on organizations and movements. In their effort to achieve political intersectionality the organizers of the march -- four mainstream feminist organizations (NOW, NARAL, Planned Parenthood and Feminist Majority Foundation) – sought the endorsement of the women of color organization SisterSong. This organization successfully demanded the inclusion of women of color organizations in the managing and steering committees, the renaming of the March and the shift from “reproductive rights” to “reproductive justice” thus moving away from individual rights to a broader social justice frame. The coalition work thus resulted in a shift to a broader and more inclusive frame which recognized the positionality of women of color. Any effort to achieve political intersectionality and to create and maintain coalitions requires effective communication, inter-cultural dialogue and understanding. This means that preferences for different strategies and actions need to be respected. Karma Chavez (2012) observed conflicts around agenda setting and forms of activism in an LGBT organization which was shaped by power differences between differently positioned activists. Strolovitch (2007) also notes that coalitions reproduce the challenges of representing and advocating for disadvantaged groups.

Groups and organizations that are aware of power differentials among activists employ strategies in order to give voice to groups which are at risk of exclusion. One of these strategies is the “progressive stack” (Maharawal 2013), which means alternating speakers representing different groups and constituencies. In multi-lingual settings, translation and multi-lingual facilitation offer potentially inclusive language practices (Doerr 2008). Based on participatory action research with the UK anti-austerity group Sisters Uncut, Armine Ishkanian and Anita Peña Saavedra (2019) identify “intersectional prefiguration” which they understand as radical, democratic politics that acknowledge and challenge inequality, structures of power and

oppression within a social movement organization. This means that in order to achieve political intersectionality, social movements and social movement organizations need to acknowledge structural intersectionality and assure that the framing of issues and adoption of strategies takes into consideration different styles of communication, power differences and unequal access to resources. Successful political intersectionality requires transversal politics (Yuval-Davis 2006) that is based on dialogue and the acknowledgement of differences in social, economic and political power (structural intersectionality).

# Conclusions and Call for Future Research

In this article, I have argued and demonstrated that an intersectional perspective makes an important contribution to the understanding of processes and strategies of all kinds of social movements. Analyses that overlook structural inequality engage in colorblind or genderblined intersectionality (Carbado 2013) and are deeply problematic. An intersectional perspective acknowledges that movements are always shaped by multiple axes of dominance, this applies to movements which represent ethnic minority working-class women and to those of white middle class men as well as those which bring together activists from different genders, classes, and ethnicities. It is thus important to acknowledge structural intersectionality and evaluate strategies to achieve political intersectionality, namely, to include marginalized groups and be aware of power differentials. This is important for every movement, on the left and on the right. I have therefore argued that intersectional perspective should be more widely employed in social movement research, especially in order to understand obstacles to and opportunities for creating and maintaining broad and inclusive alliances. Intersectional perspectives make the unmarked, privileged, and normative positions of white, male, middle-class, heterosexual constituencies

visible (Carbado 2013; Choo & Ferree 2010). While some warn that extending the use of the concept intersectionality might depoliticize it (Chandra Talpade Mohanty 2013; Bilge 2013; Bilge 2014), I understand intersectionality as an analytic strategy and a form of critical practice (Hill Collins 2015). I have argued that, as long as intersectionality is primarily identified with the mobilization of women of color and associated with women’s and feminist movements, the full potential of this concept is not appreciated and utilized. Furthermore, I have discussed strategies to achieve political intersectionality, in particular coalition building.

I suggest five broad strategies of furthering the scholarship of intersectionality in social movements and social movement organizations. First, it is important pay more attention to privileged and unmarked categories (middle-class, white, male, cis-gender, heterosexual, ablebodied, etc.) (Choo & Ferree 2010; Carbado 2013). Second, intersectional perspectives should address the role of class differences and masculinities in social movements. Third, it is important to understand nationalist and populist mobilizations which attack and seek to “undo” intersectionality (Kuhar & Paternotte 2018; Verloo & Paternotte 2018; Dursun 2019; Ferree 2020). Fourth, the systematic study of the (failed) efforts to achieve political intersectionality would benefit from a focus on specific temporary and spatial contexts and/or organizationally bounded networks. Above, I have discussed the World Women’s March and Black Lives Matter, in addition such settings include social movement organizations, networks or campaigns, such as the Coalition of Labour Union Women (CLUW)(Roth 2003; 2005; 2008; Kirton 2015), Occupy (Maharawal 2013; Roth, Saunders & Olcese 2014; Eschle 2018; Montoya 2019; Milkman 2017; Einwohner et. al. 2019) or the World Social Forum (Doerr 2008; Conway 2011; Siméant 2013). These contexts provide a good lens to analyse obstacles and strategies to achieve political

intersectionality including both conflicts and tensions and the acknowledgement and inclusion of the various interests of heterogeneous constituencies. Fifth, it is important to pay more attention to intersectional processes in social movements beyond Europe and North America (see for example de Jong 2017; Subramaniam & Krishnan 2019; Teixeira & Motta 2020). An intersectional perspective on social movements takes into account that movements are gendered, as well as classed, racialized, heteronormative and so on.

# Endnotes

1. Due to space limitations I do not address additional strategies to conceptualize and research intersectionality (see for example McCall 2005; Hancock 2007; Choo & Ferree   
2010).   
2. Sub-groups of those who are affected by HIV and AIDS must not only be distinguished with respect to gender, race and sexuality, but also by different circumstances that led to the infection.   
3. Front national (National Front) is a right-wing French party which was founded in 1972. In 2018, it renamed itself Rassemblement National (National Rally) (Geva 2020).

# Bibliography

Agustin, L. R. & Roth, S. (2011). Minority Inclusion, Self-Representation and CoalitionBuilding: The Participation of Minority Women in European Women's Networks. In A. E. Woodward, J.-M. Bonvin and M. Renom (Eds.), Transforming Gendered Well-Being in Europe. The Impact of Social Movements. (pp. 231-247) Farnham: Ashgate.   
Anthias, F. & Yuval-Davis, N. (1993). Racialized Boundaries: Race, Nation, Gender, Colour and Class and the Anti-Racist Struggle, New York: Taylor & Francis.   
Ayoub, P. M. (2019). Intersectional and Transnational Coalitions during Times of Crisis: The European LGBTI Movement. Social Politics: International Studies in Gender, State & Society 26(1), 1-29   
Barnett, B. M. (1993). Invisible Southern Black Women Leaders in the Civil Rights Movement. The Triple Constraints of Gender, Race, and Class. Gender & Society 7, 162-182.   
Baron, A. (1991). Work engendered: Toward a new history of American labor, Ithaca: Cornell University Press.   
Bassel, L. & Emejulu, A. (2010). Struggles for Institutional Space in France and the United Kingdom: Intersectionality and the Politics of Policy. Politics & Gender 6(04), 517-544. Bassel, L. & Emejulu, A. (2014). Solidarity under Austerity: Intersectionality in France and the United Kingdom. Politics & Gender 10(01), 130-136.   
Bassel, L. & Emejulu, A. (2017). Minority women and austerity. Survival and resistance in France and Britain. Bristol: Policy Press. Beamish, T. D. & Luebbers, A. J. (2009). Alliance Building across Social Movements: Bridging Difference in a Peace and Justice Coalition. Social Problems 56(4), 647-676.   
Beckwith, K. (2000). Beyond compare? Women's movements in comparative perspective. European Journal of Political Research 37(4), 431-468.   
Bell, S. E. & Braun, Y. A. (2010). Coal, Identity, and the Gendering of Environmental Justice Activism in Central Appalachia. Gender & Society 24(6), 794-813.   
Benford, R. D. & Snow, D. A. (2000). Framing Processes and Social Movements: An Overview and Assessment. Annual Review of Sociology 26, 611-639.   
Bilge, S. (2013). Intersectionality Undone. Saving Intersectionality from Feminist   
Intersectionality Studies Du Bois Review: Social Science Research on Race 10(2): 405-424. Bilge, S. (2014). Whitening intersectionality. In W. D. Hund and A. Lentin (Eds.), Racism and sociology (pp. 175-205). Muenster, Lit Verlag.   
Blee, K. M. (2016). Personal Effects from far-right activism. In L. Bosi, M. Giugni and K. Uba (Eds.), The Consequences of Social Movements (pp. 66-84). Cambridge: Cambridge University Press.   
Blee, K. M. & Deutsch, S. M. (2012) (Eds.), Women of the Right: Comparisons and Interplay Across Borders. State College, PA, Penn State University Press.   
Boon, G. M., Secci, J. & Gallan, L.M. (2018). Resistance: Active and Creative Political Protest Strategies. American Behavioral Scientist 62(3), 353-374.   
Boothroyd, S., Bowen, R, Cattermole, A. Chang-Swanson, K. Daltrop, H. Dwyer, S. Gunn, A. Kramer, B., McCartan, D. M. Nagra, J., Samimi, S. & Yoon-Potkins, Q. (2017). (Re)producing feminine bodies: emergent spaces through contestation in the Women’s March on Washington.   
Gender, Place & Culture 24(5), 711-721. Brown, M., Ray, R. Summers, E. & Fraistat, N. (2017). #SayHerName: a case study of intersectional social media activism. Ethnic and Racial Studies 40(11), 1831-1846.   
Bullard, R. D. (1990). Dumping in Dixie: Race, Class and Environmental Quality. New York: Columbia University Press.   
Bunnage, L. A. (2014). Interrogating the interaction of race, gender, and class within U.S. labor movement revitalization efforts. Women's Studies International Forum 47, 63-76.   
Burke, S., Carr, A., Casson, H., Coddington, K., Colls, R., Jollans, A., Jordan, S., Smith, K., Taylor, N., and Urquhart, H. (2017). Generative spaces: intimacy, activism and teaching feminist geographies. Gender, Place & Culture 24(5), 661-673.   
Bystydzienski, J. M. & Schacht, S. P. (2001). Forging Radical Alliances across Difference. Coalition Politics for the New Millennium. Oxford: Rowman and Littlefield.   
Carbado, D. W. (2013). Colorblind Intersectionality. Signs: Journal of Women in Culture and Society 38(4): 811-845.   
Carbado, D. W. & Harris, C. I. (2019). Intersectionality at 30: Mapping the margins of AntiEssentialism, Intersectionality, and Dominance Theory. Harvard Law Review 138(8).   
Chavez, K. R. (2012). Power, Privilege, and Identities in Political Activist Communities. In N. Bardan and M. P. Orbe (Eds.). Identity research and communication: Intercultural reflections and future directions (pp. 21-32). Lanham, Maryland: Rowman & Littlefield.

Cho, S., Crenshaw, K. W. & McCall, L. (2013). Toward a Field of Intersectionality Studies: Theory, Applications, and Praxis. Signs: Journal of Women in Culture and Society, 38(4), 785- 810.

Choo, H. Y. & Ferree, M. M. (2010). Practising Intersectionality in Sociological Research: A Critical Analysis of Inclusion, Interaction and Institutions in the Study of Inequalities. Sociological Theory 28(2), 129-149.

Chun, J. J., Lipsitz, G. & Shin, Y. (2013). Intersectionality as a Social Movement Strategy: Asian Immigrant Women Advocates. Signs: Journal of Women in Culture and Society 38(4), 917-940.

Clark, A. D., Dantzler, P. A. & Nickels, A. E. (2018). Black lives matter:(Re) framing the next wave of black liberation. Research in Social Movements, Conflicts and Change, 42, 145-171

Cockburn, C. (1983). Brothers: Male Dominance and Technological Change. London: Pluto Press.

Cohen, R. B. (2012). Researching difference and diversity within women's movements: Sisterhood and after. Women's Studies International Forum 35(3), 138-140.

Cole, E. R. (2008). Coalitions as a model for intersectionality: From practice to theory. Sex Roles 59: 443-453.

Cole, E. R. & Luna, Z. T. (2010). Making Coalitions Work: Solidarity across Difference within US Feminism. Feminist Studies 36(1), 71-98,231.

Conway, J. (2011). Cosmopolitan or Colonial? The World Social Forum as ‘contact zone’. Third World Quarterly 32(2), 217-236.

Costanza-Chock, S. (2014). Out of the Shadows, Into the Streets! Transmedia Organizing and the Immigrant Rights Movement. Cambridge, MA: MIT Press.

Crenshaw, K. W. (1989). Demarginalizing the Intersection of Race and Sex: A Black Feminist Critique of Antidiscrimination Doctrine, Feminist Theory and Antiracist Politics. University of Chicago Legal Forum: 139-167.

Crenshaw, K. (1991). Mapping the margins: intersectionality, identity, politics and violence against women of color. Stanford Law Review, 43: 1241.

Deegan, J. (1988). Jane Addams and the Men of the Chicago School, 1892-1918. New Brunswick, Transaction Press.

de Jong, S. (2017). Complicit Sisters: Gender and Women's Issues across North-South Divides.   
New York: Oxford University Press.

Di Chiro, G. (2008). Living environmentalisms: coalition politics, social reproduction, and environmental justice. Environmental Politics 17(2), 276-298.

Dixon, M. & Martin, A. W. (2012). We Can't Win This on Our Own: Unions, Firms, and Mobilization of External Allies in Labor Disputes. American Sociological Review 77(6), 946- 969.

Doan, P. (2017). Coming out of darkness and into activism. Gender, Place & Culture 24(5), 741- 746.

Doerr, N. (2008). Deliberative discussion, language, and efficiency in the World Social Forum process. Mobilization: An International Quarterly 13(4), 395-410.

Dubofsky, M. & Dulles, F. R. (2014). Labor in America: A history, John Wiley & Sons.

Dursun, A. (2019) Counter-Intersectionality: The Politics of Conservative Women’s NGOs in Turkey. In Jill Irvine, Sabine Lang, and Celeste Montoya (eds) Gendered Mobilizations and Intersectional Challenges. Contemporary Social Movements in Europe and North America (pp. 74-91). London/New York: Rowman & Littlefield.   
Einwohner, R. L., Kelly-Thompson, K., Sinclair-Chapman, V., Tormos-Aponte, F., Weldon, S. L., Wright, J. M. & Wu, C. (2019). Active Solidarity: Intersectional Solidarity in Action. Social Politics: International Studies in Gender, State & Society. https://doi.org/10.1093/sp/jpxz052 Eschle, C. (2018). Troubling stories of the end of occupy: Feminist narratives of betrayal at occupy Glasgow. Social Movement Studies 17(5), 524-540.   
Evans, S. (1979). Personal Politics. The Roots of Women's Liberation in the Civil Rights Movement and the New Left. New York: Alfred A. Knopf.   
Falola, B. & West Ohueri, C. (2017). Resist, persist, desist: building solidarity from Grandma Ella through baby Angela to the Women’s March. Gender, Place & Culture 24(5), 722-740. Ferber, A. L. (2000). "Racial Warriors and Weekend Warriors:The Construction of Masculinity in Mythopoetic and White Supremacist Discourse." Men and Masculinities 3(1): 30-56. Ferree, M. M. (2009). Inequality, Intersectionality and the Politics of Discourse. Framing Feminist Alliances. In E. Lombardo, P. Meier and V. Verloo (eds) The Discursive Politics of Gender Equality: Stretching, Bending, and Policy-Making (pp. 84-111). London: Routledge. Ferree, M.M. (2020). The Crisis of Masculinity for Gendered Democracies: Before, During, and After Trump. Sociological Forum DOI: 10.1111/socf.12599

Ferree, M. M. & Hess, B. B. (2000). Controversy and Coalition: The New Feminist Movement Across Four Decades of Change. London, GBR, Routledge.

Ferree, M. M. & C. McClurg Mueller, C. (2007). Feminism and the Women's Movement: A Global Perspective. In D. Snow, S. A. Soule and H. Kriesi (Eds.), The Blackwell Companion to Social Movements (pp. 576-607). Oxford: Blackwell.

Ferree, M. M. & Roth, S. (1998). Gender, Class and the Interaction between Social Movements.   
A Strike of West Berlin Day Care Workers. Gender & Society 12(6), 626-648.

Fisher, D. R. (2019). American Resistance. From the Women's March to the Blue Wave. New York, Columbia University Press.

Fisher, D. R. (2020). "The diversity of the recent Black Lives Matter protests is a good sign for racial equity." How we Rise blog, from https://www.brookings.edu/blog/how-werise/2020/07/08/the-diversity-of-the-recent-black-lives-matter-protests-is-a-good-sign-for-racialequity/?preview_id $=$ 900068.

Fisher, D. R., Dow, D. M. & Ray, R. (2017). Intersectionality takes it to the streets: Mobilizing across diverse interests for the Women’s March. Science Advances 3(9), eaao1390.

Fonow, M. M. (2003). Union Women. Forging Feminism in the United Steelworkers of America.   
Minneapolis: University of Minnesota Press.

Garza, A. (2014). "A herstory of the# BlackLivesMatter movement." Are all the women still white? Rethinking race, expanding feminisms, 23-28.

Gawerc, M. I. (2020). "Diverse social movement coalitions: Prospects and challenges." Sociology Compass 14(1): e12760.

Geva, D. (2020). Daughter, Mother, Captain: Marine Le Pen, Gender, and Populism in the French National Front. Social Politics: International Studies in Gender, State & Society 27(1): 1- 26.

Gökarıksel, B. & Smith, S. (2017). Intersectional feminism beyond U.S. flag hijab and pussy hats in Trump’s America. Gender, Place & Culture 24(5), 628-644.   
Hancock, A.-M. (2007). Intersectionality as a Normative and Empirical Paradigm. Politics & Gender 3(2), 248-254.   
Heery, E. & Conley, H. (2007). Frame Extension in a Mature Social Movement: British Trade Unions and Part-time Work, 1967-2002. Journal of Industrial Relations 49(1), 5-29.   
Heery, E., Williams, S. & Abbott, B. (2012). Civil society organizations and trade unions: cooperation, conflict, indifference. Work, Employment & Society 26(1), 145-160.   
Hill Collins, P. (1990). Black Feminist Thought. Knowledge, Consciousness and the Politics of Empowerment. New York: Routledge.   
Hill Collins, P. (2012). Social Inequality, Power, and Politics: Intersectionality and American Pragmatism in Dialogue. Journal of Speculative Philosophy 26(2), 442-457.   
Hill Collins, P. (2015). Intersectionality's Definitional Dilemmas. Annual Review of Sociology 41(1), 1-20.   
Hughey, M. W. (2012). Black Guys and White Guise. Journal of Contemporary Ethnography 41(1), 95-124.   
Hull, G. T., Bell Scott, P. & Smith, B. (Eds.) (1982). But Some of Us Are Brave: All the Women Are White, All the Blacks Are Men: Black Women's Studies. New York: Feminist Press.

Hutchinson, D. L. (2000). Identity crisis: intersectionality, multidimensionality, and the development of an adequate theory of subordination. Michigan Journal of Race & Law 6: 285- 317.

Irazábal, C. & Huerta, C. (2016). Intersectionality and planning at the margins: LGBTQ youth of color in New York. Gender, Place & Culture 23(5), 714-732.

Irvine, J, Lang, S., & Montoya, C. (Eds.) (2019). Gendered Mobilizations and Intersectional Challenges. Contemporary Social Movements in Europe and North America. London/New York: Rowman & Littlefield.

Ishkanian, A. & Peña Saavedra, A. (2019). The politics and practices of intersectional prefiguration in social movements: The case of Sisters Uncut. The Sociological Review 67(5), 985-1001.

Kirton, G. (2015). The Coalition of Labor Union Women: Still a Space of Social Creativity and a Force for Social Change? Labor Studies Journal 40(2), 129-148.

Kirton, G. & Healy, G. (2013). Commitment and collective identity of long-term union participation: the case of women union leaders in the UK and USA. Work, Employment & Society 27(2), 195-212.

Kuhar, R. & Paternotte, D. (Eds.) (2017). Anti-gender campaigns in Europe: Mobilizing against equality. London/New York: Rowman & Littlefield International.

Kuumba, M. B. (2001). Gender and Social Movements, Sage.

Kuumba, M. B. (2002). You've Struck a Rock: Comparing Gender, Social Movements, and Transformation in the United States and South Africa. Gender & Society 16(4), 504-523.

Lépinard, É. (2014). Doing Intersectionality: Repertoires of Feminist Practices in France and Canada. Gender & Society 28(6), 877-903.

Luna, Z. T. (2010). Marching Toward Reproductive Justice: Coalitional (Re) Framing of the March for Women’s Lives. Sociological Inquiry 80(4), 554-578.   
Luna, Z. (2016). Truly a Women of Color Organization: Negotiating Sameness and Difference in Pursuit of Intersectionality. Gender & Society 30(5), 769-790.   
Luna, Z., Jesudason, S. & Kim, M. E. (2020). Turning toward intersectionality in social   
movement research. Mobilization: An International Quarterly 25(4): 435-440.   
Maharawal, M. M. (2013). Occupy Wall Street and a Radical Politics of Inclusion. The   
Sociological Quarterly 54(2), 177-181.   
Mann, S. A. (2011) Pioneers of U.S. Ecofeminism and Environmental Justice. Feminist   
Formations 23(2), 1-25.   
Marks, G. W. (2014). Unions in politics: Britain, Germany, and the United States in the nineteenth and early twentieth centuries, Princeton: Princeton University Press.   
Mayer, B., Brown, P. & Morello-Frosch, R. (2010). Labor-Environmental Coalition Formation: Framing and the Right to Know. Sociological Forum 25(4), 746-768.   
McAdam, D. (1988). Freedom summer, New York: Oxford University Press.   
McCall, L. (2005). The Complexity of Intersectionality. Signs: Journal of Women in Culture and Society 30(3), 1771-1880.   
McVeigh, R. (1999). Structural Incentives for Conservative Mobilization: Power Devaluation and the Rise of the Ku Klux Klan, 1915-1925. Social Forces 77(4): 1461-1496. McVeigh, R. & Estep, K. (2019). The Politics of Losing. Trump, the Klan and the   
Mainstreaming of Resentment. New York, Columbia University Press.   
Milkman, R. (1990). Gender and Trade Unions in Historical Perspective. In L.A. Tilly and P. Gurin (Eds.), Women, Politics and Change (pp. 87-107). New York: Russel Sage Foundation. Milkman, R. (2017). A New Political Generation: Millennials and the Post-2008 Wave of Protest. American Sociological Review 82(1), 1-31.   
Milkman, R. (2018). Trump and the Future of U. S. Labor: An Intersectional Perspective. Novos estudos CEBRAP 37: 99-115.   
Mohanty, C. T. (2003). Under Western Eyes Revisited: Feminist Solidarity through   
Anticapitalist Struggles. Signs: Journal of Women in Culture and Society 28(2), 499-535. Mohanty, C. T. (2013). Transnational Feminist Crossings: On Neoliberalism and Radical Critique. Signs: Journal of Women in Culture and Society 38(4), 967-991.   
Montoya, C. & Seminario, M. G. (2020). Guerreras y Puentes: the theory and praxis of Latina(x) activism. Politics, Groups, and Identities: 1-18.   
Montoya, C. (2019) From Identity Politics to Intersectionality? Identity -Based Organizing in the Occupy Movements. In Jill Irvine, Sabine Lang, and Celeste Montoya (eds) Gendered   
Mobilizations and Intersectional Challenges. Contemporary Social Movements in Europe and North America (pp. 135-153). London/New York: Rowman & Littlefield.   
Moore, S. & Taylor, P. (2020) "Class Reimagined? Intersectionality and Industrial Action – the British Airways Dispute of 2009–2011." Sociology Online first   
https://doi.org/10.1177/0038038520973603 Moss, P. & Maddrell, A. (2017). Emergent and divergent spaces in the Women’s March: the challenges of intersectionality and inclusion. Gender, Place & Culture 24(5), 613-620.   
Mustchin, S. (2012). Unions, learning, migrant workers and union revitalization in Britain. Work, Employment & Society 26(6), 951-967.   
Oliver, P. (2020). Resisting Repression: The Black Lives Movement in Context. In H Johnston and P. Oliver (Eds.), Racialized Protest and the State: Resistance and Repression in a Divided America. New York: Routledge, pp. 63-88..   
Perrett, R. & Lucio, M.M. (2009). Trade Unions and Relations with Black and Minority-Ethnic Community Groups in the United Kingdom: The Development of New Alliances? Journal of Ethnic and Migration Studies 35(8), 1295 - 1314.   
Polletta, F. (2005). How Participatory Democracy Became White: Culture and Organizational Choice. Mobilization 10(2), 271-288.   
Ransby, B. (2000). Black Feminism at Twenty-One: Reflections on the Evolution of a National Community. Signs: Journal of Women in Culture and Society 25(4), 1215-1221.   
Ransby, B. (2015). The class politics of black lives matter. Dissent 62(4), 31-34.   
Ransby, B. (2018). Making All Black Lives Matter: Reimagining freedom in the 21st Century. Oakland: University of California Press.   
Roberts, D. & Jesudason, S. (2013). Movement Intersectionality. The Case of Race, Gender, Disability, and Genetic Technologies. Du Bois Review: Social Science Research on Race 10(02), 313-328. Robnett, B. (1996). African-American women in the civil rights movement, 1954-1965: Gender, leadership, and micromobilization. American Journal of Sociology 101(6), 1661-1693.   
Rose-Redwood, C. & Rose-Redwood, R. (2017). ‘It definitely felt very white’: race, gender, and the performative politics of assembly at the Women’s March in Victoria, British Columbia. Gender, Place & Culture 24(5), 645-654.   
Rose, F. (1999). Coalitions Across the Class Divide: Lessons from the Labor, Peace and Environmental Movements. Ithaca: Cornell University Press.   
Roth, B. (2004). Separate Roads to Feminism. Black, Chicana and White Feminist Movements in America's Second Wave. Cambridge, Cambridge University Press.   
Roth, B. (2017a). Intersectionality: Origins, Travels, Questions, and Contributions. In H. J. McCammon, V. Taylor, J. Reger and R. Einwohner (eds) The Oxford Handbook of U.S. Women's Social Movement Activism (pp. 129-149). Oxford, Oxford University Press.   
Roth, B. (2017b). The Life and Death of ACT-UP LA. Cambridge, Cambridge University Press. Roth, S. (2003). Building Movement Bridges. The Coalition of Labor Union Women.   
Greenwood, CT, Praeger.   
Roth, S. (2005). Sisterhood and exclusionary solidarity in a labor women's organization. In H. Flam and D. King (eds) Emotions and Social Movements (pp. 189-206). New York, Routledge. Roth, S. (2008). Dealing with Diversity: The Coalition of Labor Union Women. In R.   
Einwohner, J. Reger and D. Myers (eds) Identity Work, Sameness and Difference in Social Movements (pp. 213-131). Minneapolis, University of Minnesota Press. Roth, S., Saunders, C. & Olcese, C. (2014). Occupy as a Free Space - Mobilization Processes and Outcomes. Sociological Research Online 19(1), 1.   
https://journals.sagepub.com/doi/full/10.5153/sro.3201

Saunders, C. (2013). Environmental Movements and Social Movement Theory. London, Bloomsbury Academic.

Schroer, T. (2008). Technical Advances in Communication: The Example of White Racialist Love Groups and White Civil Rights Organizations. In R. Einwohner, J. Reger and D. Myers (Eds.), Identity Work, Sameness and Difference in Social Movements (pp. 77-99). Minneapolis: University of Minnesota Press.

Scrinzi, F. (2015). Righteous patriots, corrupted elites, undeserving poors. The construction of multiple social boundaries in the National Front. Etnografia e Ricerca Qualitativa(1), 55-74.

Siméant, J. (2013). Committing to Internationalisation: Careers of African Participants at the World Social Forum. Social Movement Studies 12(3), 245-263.

Simi, P., Futrell, R. & Bubolz, B.F. (2016). Parenting as Activism: Identity Alignment and Activist Persistence in the White Power Movement. The Sociological Quarterly 57(3): 491-519.

Strolovitch, D. Z. (2007). Affirmative Advocacy. Race, Place, and Gender in Interest Group Politics. Chicago/London, University of Chicago Press.

Stuart, M., Tomlinson, J. & Lucio, M.M. (2013). Women and the Modernization of British Trade Unions: Meanings, Dimensions and the Challenge of Change. Journal of Industrial Relations 55(1), 38-59.

Subramaniam, M. & Krishnan, P. (2019). Intersections of gender, caste and class: Agenda building in the Indian women’s movement. In Aneja, A. (Ed.), Women’s and Gender Studies in India (pp. 55-65). Routledge India.   
Taylor, D. E. (1997). American Environmentalism: The Role of Race, Class and Gender in Shaping Activism 1820-1995. Race, Gender & Class 5(1): 16-62.   
Taylor, D. E. (2015). Gender and Racial Diversity in Environmental Organizations: Uneven Accomplishments and Cause for Concern. Environmental Justice 8(5): 165-180.   
Teixeira, M. A. & Motta, R. (2020). "Unionism and feminism: alliance building in the Brazilian Marcha das Margaridas." Social Movement Studies: 1-17.   
https://www.tandfonline.com/doi/full/10.1080/14742837.2020.1770430   
Terriquez, V. (2015). Intersectional Mobilization, Social Movement Spillover, and Queer Youth Leadership in the Immigrant Rights Movement. Social Problems 62(3), 343-362.   
Van Dyke, N. & McCammon, H. (Eds.) (2010). Strategic Alliances. Coalition Building and Social Movements. Minneapolis: University of Minnesota Press.   
Verloo, M. (2013). Intersectional and Cross-Movement Politics and Policies: Reflections on Current Practices and Debates. Signs: Journal of Women in Culture and Society, 38 (4), 893-915. Verloo, M. & Paternotte, D. (2018). The Feminist Project under Threat in Europe. Politics and Governance 6(3), 1-5.   
Walby, S. (2009). Globalization and Inequalities. Complexity and Contested Modernities. Los Angeles: Sage.

Yuval-Davis, N. (2006). Human/Women's Rights and Feminist Transversal Politics. In M. M. Ferree and A. M. Tripp (Eds.), Global Feminism. Transnational Women's Activism, Organising and Human Rights (pp. 275-295). New York: NYU Press. Zavella, P. (2017). Intersectional Praxis in the Movement for Reproductive Justice: The Respect ABQ Women Campaign." Signs: Journal of Women in Culture and Society 42(2), 509-533.

Autor’s biography: Silke Roth’s research is located at the intersection of political sociology and the sociology of work. Her expertise comprises social movement studies, humanitarian studies, sociology of gender, military sociology, and digital sociology. The red thread that runs through her work is the question how organisations overcome and perpetuate inequality through the inand exclusion of different constituencies in membership and leadership, and through their goals and objectives. She is the author of Building Movement Bridges (Greenwood 2003), The Paradoxes of Aid Work (Routledge 2015) and numerous book chapters and articles which appeared in Information, Communication and Society; Interface; Gender & Society; Social Movement Studies; Social Politics; Sociological Research Online; Sociology; and Third World Quarterly. Her current research concerns veterans’ transition from the military to civilian work and life and the transfer of military knowledge and practices to humanitarianism and disaster relief. Furthermore, building on her earlier research on the third sector, social movements, and humanitarianism she is now studying the impact of information and communication technologies (ICT) on these fields. She holds a PhD in Sociology from the University of Connecticut, taught at the University of Pennsylvania, and is currently Professor of Sociology at the University of Southampton (UK).